'Programm ......... : Ultraschallerzeugung zur Vergrmung von Tieren
'
'Programminhalt ... : - Tonerzeugung im Ultraschallbereich (Tonspektrum)
'        Betriebsart: - Funktionstaste 1 (FT1): Umschaltung Frequenz
'                       a) Tonerzeugung im Ultraschallbereich
'                       b) Tonerzeugung im hrbaren Bereich
'                     - Funktionstaste 2 (FT 2): Umschaltung Betriebsart
'                       Dauerbetrieb fr 3 Tage
'     Signalisierung: - LED_Programmstart
'                       LED_gn: 3x Impuls: Programm gestartet
'                     - LED_Betrieb
'                       LED_rt: whrend der Tonausgabe (Ultraschall)
'                       LED_gn: whrend der Tonausgabe (Hrbereich)
'                     - Ton_Tastensbesttigung
'                       Signalton zur Besttigung eines Tastendruckes
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' nicht impementiert: - Auswertung der Umgebungshelligkeit
' (LP vorbereitet)    - Funkuhrmodul
'                     - Funktionstasten FT2 (FT3)
'                     - Akkubetrieb (Ladeung/Erhaltungsladung)
'
'Programmierer .... : Ingolf Bauer (ingolf.bauer@nexgo.de)
'Version .......... : V 1.4
'Datum ............ : 23.12.2017
'
'-------------------------------------------------------------------------------
'
'Simulator-Einstellmglichkeit
'-----------------------------
'$sim                                              'Wartezeit aus
'
' Achtung!
' Diese Zeile ist unbedingt auszukommentieren, bevor der AVR programmiert wird,
' da sonst der AVR nicht korrekt arbeitet.
' Die Aktivierung ist nur fr den Simulator vorgesehen.

'-------------------------------------------------------------------------------
'00. === I N F O R M A T I O N =================================================
'-------------------------------------------------------------------------------
A_01_historie:
'
'Versionsbersicht
'-----------------
'Implementierung offen: - Funkuhr, Umgebungshelligkeit, Ladebetrieb (Akku)
'
'
'
'
'
'
'
'V 1.4 23.12.2017 - Kommentierung : - Eintrag diverser Kommentare
'V 1.3 18.12.2017 - Erweiterung . : - Umschaltbar auf Dauerbetrieb fr 3 Tage
'V 1.2 14.12.2017 - Kommentierung : - Kommentierung des Programmcodes
'V 1.1 13.12.2017 - Entwicklung . : - Abschluss Tonerzeugung (Datenfelder)
'V 0.1 09.11.2017 - Information . : - Beginn der Softwareentwicklung
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'
'Programmspeicher des MCs (Programm-Flashspeicher): V 1.4 - 54%
'
'-------------------------------------------------------------------------------
'
'Informationen zur Software
'--------------------------
' Inhalt                                                                | Zeile
'-------------------------------------------------------------------------------
' 01. Allgemeine Informationen ........................................ |   95
' 02. Abkrzungsbersicht ............................................. |  113
' 03. Compilereinstellungen ........................................... |  117
' 04. Funktionsbeschreibung ........................................... |  141
' 05. Interrupt ....................................................... |  145
' 06. Einstellung der FUSE- und/oder LOOK-Bits ........................ |  152
' 07. Anschluschema fr den AVR (ATmega8) ............................ |  195
' 08. Belegung ........................................................ |  224
'      bersicht ...................................................... |  262
' 08.1 Steckverbinder ................................................. |  305
' 08.2 Jumper ......................................................... |  315
' 10. Allgemein ....................................................... |  326
' 11. Schaltkreis ..................................................... |  330
' 12. Deklaration ..................................................... |  349
' 13. I/O-Ports Konfiguration ......................................... |  399
' 14. Alias ........................................................... |  427
' 15.1 Analog/Digital Konverter ....................................... |  463
' 15.2 Konfiguration Timer ............................................ |  474
' 15.3 Konfiguration Watchdog ......................................... |  511
' 16. Konfiguration Interrupt ......................................... |  521
' 17. Initialisierung ................................................. |  532
' 20. Programm ........................................................ |  561
' 30. Interruptroutine ................................................ |  634
'      Timer 0 ........................................................ |  638
' 40. Unterprogramm ................................................... |  668
' 50. Unterprogramm-Call .............................................. |  707
'-------------------------------------------------------------------------------
'
'01. Allgemeine Informationen
'----------------------------
' - Stromversorgung
'   Diese kann auf verschiedene Arten bereitgestellt werden:
'   > direkter Betrieb mit +5 V
'   > Betrieb mit einer Gleichspannung im Bereich von ca. 7-12 V (Netzbetrieb)
'   > Batterie- oder Akkkubetrieb (parallel zum Netzbetrieb mglich)
'
'   Fr eine korrekte Arbeitsweise ist die jeweilige Konfiguration der Jumper
'   (X102, X103) zu beachten und ggf. die Software zu erweitern bzw. anzupassen.
'   (z. B. Lademodies bei Akkubetrieb)
'
' - Taktfrequenz
'   Fr die AVR-Takterzeugung wird ein Quarz (16,0 MHz) eingesetzt.
'
' - Programmierung
'   Die Programmierung erfolgt ber den Steckverbinder X210.
'
'02. Abkrzungsbersicht
'-----------------------
' - entfllt -
'
'03. Compilereinstellungen
'-------------------------
' Hinweise fr ATmega8/ATmega16 mit 1024 Byte SRAM
' Sie gelten ggf. auch fr den hier eingesetzten Mikrocontroller.
' Quelle:
' //halvar.at/elektronik/kleiner_bascom_avr_kurs/speicher_hwstack_swstack_frame/
'
' HW-Stack    - Empfehlung: 40 Byte bei INT, sonst 10 Byte ausreichend
'  32 Byte fr INT + je GOSUB 2 Byte, wenn bei INT ein GOSUB erfolgt
'  (bei Verschachtelung ... + n x 2 Byte)
'
' SW-Stack    - Empfehlung: 32 Byte (recht komplexe Aufrufe werden abgedeckt)
'   2 Byte fr jede bergebene Variable einer GOSUB-Routine + 2 Byte fr jede
'   LOCAL-Variable innerhalb einer GOSUB
'   (bei Verschachtelung ... n x 2 Byte)
'
' Frame-Space - Empfehlung: 60 Byte sollten alles abdecken
'                           (bei wenig Speicher verkleinern)
'  Beispiel:
'   2 x BYTE        =  2 Byte (erster und zweiter Parameter)
'   1 x WORD        =  2 Byte (dritte Parameter)
'   1 x STRING * 10 = 11 Byte (inkl. Abschlussbyte; vierter Parameter)
'   3 x BYTE        =  3 Byte (lokale Variablen)
'
'04. Funktionsbeschreibung
'-------------------------
' (keine Ergnzungen zur Programmbeschreibung)
'
'05. Interrupt
'-------------
' - bersicht
'   Timer 0:  8 Bit, Interrupt bei Timer-berlauf (Zeittakt 15 ms)
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'   Timer 1:  (Er wird in einem mglichen DCF-Betrieb verwendet.)
'
'06. Einstellung der FUSE- und/oder LOOK-Bits
'--------------------------------------------
' - FUSE-Einstellungen Brenner USBasp (Bascom)
'   Die Einstellungen sind ggf. per "screenshot" erstellt und im Verzeichnis zur
'   Baugruppe abgelegt.
'
' - FUSE-bersicht
'   Die angegebenen HEX-Werte knnen direkt in die Brenner-Software eingetragen
'   werden, falls dies untersttzt wird (nicht bei USBasp unter Bascom).
'
' Einstellungen bei dem USBasp-Programmer
' Name            MEGA8
'   Calibration 0   BD
'   Calibration 1   BC
'   Calibration 2   B7
'   Calibration 3   B7
' * Lockbits        FF
'    Lockbit 65       11: No restrictions for SPM or LPM accessing ...
'    Lockbit 43       11: No restrictions for SPM or LPM accessing ...
'    Lockbit 21       11: No memory lock features enabled for parallel ...
' * Fusebits        FC
'    Fusebit C         1: BODLEVEL 2.7V
'    Fusebit B         1: BODEN disabled
'    Fusebit KLA987   111100: Ext. Crystal/Resonator Medium Freq.
' * Fusebits Hight  C1
'    Fusebit High M    1: PIN PC6 is RESET
'    Fusebit High J    1: WDT enabled by WDTCR
'    Fusebit High I    0: SPI enabled
'    Fusebit High H    0: CKOPT 0
'    Fusebit High G    0: Preserve EEPROM when chip erase
'    Fusebit High FE  00: 1024 word boot size, C00'
'    Fusebit High D    1: Reset vector is $0000
'
' Achtung
' =======
' - CKSEL
'   Wird CKSEL3= 0 gesetzt, arbeitet der MC nur noch mit einem externen RC-
'   Generator [f= 1/(3RC); C>= 22p].
'
' - RSTDISBL
'   Wird RSTDISBL= 1 gesetzt, ist mit einfachen Brennern kein Programmieren
'   mehr mglich, da dafr die Reset-Funktion unbedingt erforderlich ist.
'
'07. Anschluschema fr den AVR (ATmega8)
'----------------------------------------
A_07_avr:
'
'                      --------------|_|--------------
' [1]        /RES ---> | 1 [/Reset]    [ADC5, PC5] 28| ---- X3
'            *DCF ---> | 2 [PD0, RXD]  [ADC4, PC4] 27| ---- X2
'              X1 ---- | 3 [PD1, TXD]  [ADC3, PC3] 26| ~~~~ *U_US      [mV]
' [H]         T_2 ---> | 4 [PD2, INT0] [ADC2, PC2] 25| ~~~~ *U_L       [mV]
' [H]         T_1 ---> | 5 [PD3, INT1] [ADC1, PC1] 24| ~~~~ *U_NT      [mV]
' [0]          BZ <--- | 6 [PD4, T0]   [ADC0, PC0] 23| ~~~~ *U_BAT     [mV]
'             P5V ==== | 7 [VCC]            [AGND] 22| ==== GND
'             GND ==== | 8 [GND]            [AREF] 21| -||- C
'              QZ ++++ | 9 [XT1]            [AVCC] 20| ==== P5V
'              QZ ++++ |10 [XT2]         [SCK,PB5] 19| <--- SCK        [0]
' [0]          ST <--- |11 [PD5, T1]    [MISO,PB4] 18| <--- MISO       [0]
' [f]          US <--- |12 [PD6, AIN0]  [MOSI,PB3] 17| ---> MOSI       [0]
'             *MB <--- |13 [PD7, AIN1]  [/SS, PB2] 16| ---> LED_B      [1]
' [1]       LED_R <--- |14 [PB0, ICP]   [OC1, PB1] 15| ---> LED_G      [1]
'                      -------------------------------
'
' Werte in []: Einstellungen nach dem Programmstart
'  0: aus
'  1: ein
'  H: durch Pullup-Widerstand im MC 'high'
'  f: Frequenzausgang
' mV: anliegende Analogspannung (optional)
'  x: hngt vom Einschaltzustand ab
'
'08. Belegung
'------------
' Prfix                           Suffix
'-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -
'Signale
'- - - -
' * optional (bei Programmierung oder Sensoranschluss)
' *DCF : Zeittakt vom DCF-Modul    -        : optionaler Anschluss DCF
' *MB  : Steuerung Batterie-Messung         : optional Batterie-/Akkuspannung
' *U_  : Spannungsmessung          BAT      : optional Batterie-/Akkuspannung
'                                  L        : optional Umgebungslicht
'                                  NT       : optional Netzteil
'                                  US       : optional berwachung Tonausgang
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' /RES : Resetfunktion             -
' BZ   : Ausgang open Collector    -        : optionaler Anschuss Blitz-LED
' C    : Referenzspannung an C     -
' LED_ : LED (0: Ein)              R, G, B  : Farbe (rot, grn, blau)
' ST   : Signaltongeber            -
' T_   : Taste                     1, 2     : Bedienung
' US   : Tonausgabe Ultraschall    -        : optional im hrbaren Bereich
' X    : Anschlusspunkt            1, 2, 3  : (Kanal frei belegbar)

'Stromversorgung
'- - - - - - - -
' P5V  : Stromversorgung (5 V)
' GND  : Stromversorgung (Masse)
'
'Programmierung
'- - - - - - -
' MISO : Daten
' MOSI : Daten
' SCK  : Takt

'Takterzeugung
'- - - - - - -
' QZ   : Quarz

'bersicht
'---------
'           Funktion     | Signal        | Erluterung                    | Pin
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' -   : SV  P5V ........ | ............. | Stromversorgung .............. |  7
' -   : SV  GND ........ | ............. | Stromversorgung .............. |  8
' -   : PRG /RESET ..... | ............. | Reset des MCs ................ |  1
' -   : QZ  Frequenz ... | ............. | Frequenznormal mit Quarz ..... |  9
' -   : QZ  Frequenz ... | ............. | Frequenznormal mit Quarz ..... | 10
'
'Port B     Funktion     | Signal        | Erluterung                    | Pin
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' - .0: DA  LED rot .... | LED_R ....... | Wannenstecker X111:1 ......... | 14
' - .1: DA  LED grn ... | LED_G ....... | Wannenstecker X111:3 ......... | 15
' - .2: DA  LED blau ... | LED_B ....... | Wannenstecker X111:5 ......... | 16
' - .3: PRG MOSI ....... | MOSI ........ | Programmierung ............... | 17
' - .4: PRG MISO ....... | MISO ........ | Programmierung ............... | 18
' - .5: PRG SCK ........ | SCK ......... | Programmierung ............... | 19
' - nc: ................ | ............. | .............................. | nc
' - nc: ................ | ............. | .............................. | nc
'
'Port C     Funktion     | Signal        | Erluterung                    | Pin
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' - .0: AE  Messung .... | *U_BAT ...... | Spannung Batterie ............ | 23
' - .1: AE  Messung .... | *U_NT ....... | Spannung Netzteil ............ | 24
' - .2: AE  Messung .... | *U_L ........ | Spannung Helligkeit .......... | 25
' - .3: AE  Messung .... | *U_US ....... | Spannung Ultraschall ......... | 26
' - .4: ..  ............ | ............. | X2 (freie Verfgung) ......... | 27
' - .5: ..  ............ | ............. | X3 (freie Verfgung) ......... | 28
' - nc: ................ | ............. | .............................. | nc
' - nc: ................ | ............. | .............................. | nc
'
'Port D     Funktion     | Signal        | Erluterung                    | Pin
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' - .0: DE DCF77 ....... | *DCF ........ | Anschluss Zeittakt ........... |  2
' - .1: .. ............. | X2:1 ........ | X1 (freie Verfgung) ......... |  3
' - .2: DE Taste_2 ..... | T_2 ......... | Funktionstaste 2 ............. |  4
' - .3: DE Taste_1 ..... | T_1 ......... | Funktionstaste 1 ............. |  5
' - .4: DA Blitz-LED ... | BZ .......... | offener Kollektor fr Blitz .. |  6
' - .5: DA Signalton ... | ST .......... | Signalisierung ............... | 11
' - .6: DA Tonausgabe .. | US .......... | Frequenzausgang Ultraschall .. | 12
' - .7: DA Messung ..... | *MB ......... | Steuerung Batterie-Messung ... | 13
'
'08.1 Steckverbinder
'-------------------
' X 111: Wannenstecker      Anschluss LED, Tasten

' X 202: LP-Klemmen         Anschluss Blitz-LED
' X 203: LP-Klemmen         Anschluss Schallwandler
' X 204: LP-Steckverbinder  Anschluss Funkuhrmodul (Version Pollin 2017)
' X 210: Wannenstecker      Programmieranschluss
' X 211: Wannenstecker      Stromversorgung, Zusatzmodule Lautstrke, Helligkeit

'08.2 Jumper
'-----------
'Beachte dazu bitte auch die Informationen im Stromlaufplan.
' X 102: JMP102-1/2         Akku laden
' X 102: JMP102-5/6         Reduzierung Akkuspannung_a
' X 102: JMP102-7/8         Reduzierung Akkuspannung_b

' X 201: JMP201-1/2         SV (LED, Ton): +5  V
' X 201: JMP201-2/3         SV (LED, Ton): +Ub V

'-------------------------------------------------------------------------------
'10. === A L L G E M E I N =====================================================
'-------------------------------------------------------------------------------
A_11_def:
'
'11. Schaltkreis
'---------------
   $regfile = "m8adef.dat"                        'Prozessor ....... : ATmega8
   $crystal = 16000000                            'Quarzfrequenz ... : 16,0 MHz

'Einstellungen
   $hwstack = 128                                 'Hardwarestack
   $swstack = 128                                 'Softwarestack
   $framesize = 128                               'Framespace

'Fuse- und Lookbits (generiert mit "Write PRG")
' 09.11.2017 - $prog &HFF , &HCF , &HD9 , &H00

' FF: 11 11 11
' CF: 1 1 001111       - Ext. Crystal/Resonator High Frequenz
' D9: 1 1 0 1 1 00 1
'
'-------------------------------------------------------------------------------
'
'12. Deklaration
'---------------
A_12_dec:
'
'Call
'T_s: Dauer ...... [  s]    T_f: Frequenz ... [kHz]
'T_p: Pause ...... [  s]    T_v: Version .... [  -]
   Declare Sub C_ton(byval T_s As Byte , Byval T_f As Byte , _
                      Byval T_p As Byte , Byval T_v As Byte )
'Flag
   Dim F_us As Boolean                            'Ultraschall
   Dim F_tog As Boolean
   Dim F_tas As Boolean                           'Taste gedrckt

'Konstante
   Dim K_zyk_ein As Integer                       'Zeitpunkt: Ein
   Dim K_zyk_aus As Integer                       'Zeitpunkt: Aus
   Dim K_tag As Long                              'Zeitlnge fr Dauerbetrieb

'Timer
   Dim T0_tve As Byte                             'Voreinstellwert T0

'Variable
   Dim T_1pz As Integer                           'Wert 1%
   Dim T_max As Long                              'Zeitlnge
   Dim T_max10 As Long                            '10% von <T_max>
   Dim T_sw As Integer                            'Schrittweite
   Dim T_t As Single                              'Tonlnge
   Dim T_us As Integer                            'Periodendauer
   Dim T_us90 As Integer                          'Periodendauer 90%
   Dim T_w As Single                              'Periodendauer (Zwischenwert)
   Dim T_zw As Single                             'Zwischenwert

   Dim Data_a As Byte                             'Tondauer   [s]
   Dim Data_b As Byte                             'Tonhhe    [f]
   Dim Data_c As Byte                             'Pausenzeit [s]
   Dim Data_d As Byte                             'Art der Tonausgabe

'Zhler
   Dim Z_zyk As Integer                           'Zhler Zyklus (Sekunden)
   Dim Z_led As Byte                              'Zhler LED
   Dim Z_t As Dword                               'Zhler Zeit
   Dim Z_t10 As Dword                             '10% von <Z_t>
   Dim Z_tag As Long                              'Zhler Dauerbetrieb

   Dim Hz01 As Byte                               'Hilfszhler 01
   Dim Hz_t As Long                               'Hilfszhler t
'
'-------------------------------------------------------------------------------
'
'13. I/O-Ports Konfiguration
'---------------------------
A_13_port:
'
'= Port B
'- Datenrichtung (Ein [0]: Eingang, Aus [1]: Ausgang)
   Ddrb = &B0000_0111                             'Ein: 3-7        Aus: 0-2
'- Pullup-Widerstand (passiv [0], aktiv [1])
   Portb = &B0000_0000                            'pas: 0-7        akt: -

'= Port C
'- Datenrichtung (Ein [0]: Eingang, Aus [1]: Ausgang)
   Ddrc = &B0000_0000                             'Ein: 0-7        Aus: -
'- Pullup-Widerstand (passiv [0], aktiv [1])
   Portc = &B0000_0000                            'pas: 0-7        akt: -

'= Port D
'- Datenrichtung (Ein [0]: Eingang, Aus [1]: Ausgang)
   Ddrd = &B1111_0000                             'Ein: 0-3        Aus: 4-7
'- Pullup-Widerstand (passiv [0], aktiv [1])
   Portd = &B0000_1100                            'akt: 2,3        pas: 0-1,4-7
'
'Abkrzungen fr die digitalen Kanle und den Pullup-Widerstnden
'                    Ein: Eingang             akt: aktiv
'                    Aus: Ausgang             pas: passiv
'
'-------------------------------------------------------------------------------
'
'14. Alias
'---------
A_14_alias:
'
'Hinweis:
'Nur die benutzen Kanle werden bezeichnet.
'Ausgenommen sind die Signale fr die Programmierung.
'
'-Kanal B:
' Ausgnge
   Led_zyk Alias Portb.0                          'LED rot
   Led_sig Alias Portb.1                          'LED grn
   Led_lad Alias Portb.2                          'LED blau

'-Kanal C:
' Eingnge
   U_bat As Alias Pinc.0                          'Messung Batterie-Spannung
   U_nt As Alias Pinc.1                           'Messung Netz-Spannung
   U_l Alias Pinc.2                               'Messung Lichtstrke
   U_us Alias Pinc.3                              'Messung Ultraschall

'-Kanal D:
' Eingnge
'  Dcf Alias PinD.0                               'Routine fr DCF
   T_2 Alias Pind.2                               'Taste 1
   T_1 Alias Pind.3                               'Taste 2
' Ausgnge
   S_bli Alias Portd.4                            'Signal Blitz
   T_sig Alias Portd.5                            'Signalton
   T_usg Alias Portd.6                            'Ultraschall-Geber
   M_ubat Alias Portd.7                           'Messung U_Batterie
'
'-------------------------------------------------------------------------------
'
'15.  Konfiguration
'~~~~~~~~~~~~~~~~~~
'15.1 Analog/Digital Konverter
'-----------------------------
'-Prescaler (Frequenzteiler durch 2, 4, 8, 16, 32, 64, 128)
'-ADC bentigt eine Frequenz von 50-200 kHz
'-Modus <AUTO>: hchstmgliche Frequenz wird gewhlt
'-interne Referenzspannungsquelle (2,56 V) nutzen
'-ADC erst starten, wenn Programm in die Schleife kommt!
'   Config Adc = Single , Prescaler = Auto , Reference = Internal
'
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'
'15.2 Konfiguration Timer
'------------------------
'Normal-Konfiguration (Zeitbasis fr Kodierung; 1-8-64-256-1024)
'PSC: Prescale; TZW: Timerzhlwert; TVE: Timervoreinstellwert
'       | ATmega 8   |
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' 8 bit | Timer 0, 2 |
'16 bit | Timer 1    |
'
'Berechnung der Zeitbasis:
' bei 4 MHz-Quarz Timer 1 (16 bit) verwenden
 '- - - - - - - - - - - - - - - - - - - - -
' T1 = 1/ Quarz * Teiler  * Timerzhlwert
'                     PSC   TZW
'    = 1/  4,0 MHz * 1024 * 390 = 100 ms (0,09984 s)
'
' bei 1 MHz-Quarz Timer 0 ( 8 bit) verwenden
' - - - - - - - - - - - - - - - - - - - - -
' T0 = 1/ Quarz * Teiler  * Timerzhlwert
'                     PSC   TZW
'    = 1/ 16,0 MHz * 1024 * 235 = 15 ms (0,01504 s)
'
' PSC: 8                                TZW    TVE                Toggle
' Timer ( 8 Bit) Voreinstellwert: 256 - 200 =   56   10.000 Hz =>  5.000 Hz
' Timer ( 8 Bit) Voreinstellwert: 256 - 100 =  156   20.000 Hz => 10.000 Hz
' Timer ( 8 Bit) Voreinstellwert: 256 -  67 =  188   30.000 Hz => 15.000 Hz
' Timer ( 8 Bit) Voreinstellwert: 256 -  50 =  206   40.000 Hz => 20.000 Hz
' Timer ( 8 Bit) Voreinstellwert: 256 -  40 =  216   50.000 Hz => 25.000 Hz

' Timer (16 Bit) Voreinstellwert: 65.536 - TZW = 65.146 (fr ca. 100 ms)
'
A_15_timer:
'
' Timer 0 - Zeitbasis Ein (15 ms/ 66 Hz)
   Config Timer0 = Timer , Prescale = 1024        'Konfiguration
   T0_tve = 21
'
'15.3 Konfiguration Watchdog
'---------------------------
' Bei Bedarf Code-Zeilen aktivieren, "Reset Watchdog" an geeigneter Stelle im
' Programm einfgen und neu compilieren.
'
'   Config Watchdog = 2048
'   Start Watchdog
'
'-------------------------------------------------------------------------------
'
'16. Konfiguration Interrupt
'---------------------------
A_16_int:
'
   Enable Timer0                                  'Interrupt : Timer 0
      On Timer0 Int_tim0                          'Timer 0   : berlauf

   Enable Interrupts                              'Interrupts: global zulassen
'
'-------------------------------------------------------------------------------
'
'17. Initialisierung
'-------------------
'Konstante
'- - - - -
A_17_kon:
'
'Flag fr Frequenzhhe
   Set F_us                                       'F_us= 0: Ton im Hrbereich
                                                  'F_us= 1: Ton im Ultraschall
'-Zyklus Ein [s]
   K_zyk_ein = 60                                 'Ein: 1 Minute
'-Zyklus Aus [s]
   K_zyk_aus = 180                                'Aus: 2 Minuten (180- 60= 120)
'-Zeitlnge fr Dauerbetrieb (3 Tage)
   K_tag = 259200                                 '<K_tag>= 3t* 24h* 3.600s
'
'-------------------------------------------------------------------------------
'
'LED (alle) ausschalten
   Set Led_zyk : Set Led_sig : Set Led_lad

   For Hz01 = 1 To 6                              'Anzeige, dass MC aktiv
      Toggle Led_sig
      Waitms 200
   Next Hz01

   Waitms 500

'-------------------------------------------------------------------------------
'20. === P R O G R A M M =======================================================
'-------------------------------------------------------------------------------
A_20_prg:
'
Do
'Tastenabfrage
   Gosub Up_tas

'Kodierung fr die Tonausgabe einlesen
'Soll Ultraschall (<F_us>= 1) ausgegeben werden, wird die Frequenz um 10 kHz
'erhht.
   Restore Ton_dat
M_read:
'Zyklusberwachung
   If Z_zyk > K_zyk_ein And Z_tag = 0 Then        'Dauer_Ein > Zyklus_Ein &
      Goto M_end                                  'kein Dauerbetrieb eingestellt
   End If                                         '=> keine Tonausgabe

   Read Data_a : Read Data_b : Read Data_c : Read Data_d
   If F_us = 1 Then                               'Flag: Ultraschall
      Data_b = Data_b + 10                        'Frequenz + 10 kHz
   End If
'Aufruf Tonausgabe
   If Data_a = 0 Then
      Goto M_end
   Else
      Call C_ton(data_a , Data_b , Data_c , Data_d)
      Goto M_read
   End If
M_end:
Loop

'Ende Programm
End

'21. Datenfeld
' - - - - - -
A_21_dat:
'
Ton_dat:
'<F_us>= 1, => Frequenzen + 10 [kHz] (Ultraschall)
'T: Dauer [s]   F: Frequenz [kHz]   P: Pause [s]   V: Version [-]
'       T    F    P    V
'Test
'  Data 03 , 02 , 02 , 01                             '1: Dauerton
'  Data 03 , 02 , 02 , 02                             '2: Ton anschwellend
'  Data 03 , 02 , 02 , 03                             '3: Ton abschwellend
'  Data 03 , 02 , 02 , 04                             '4: Sirene
'  Data 03 , 02 , 02 , 05                             '5: Zufall

'Programm
   Data 03 , 06 , 02 , 01
   Data 03 , 06 , 02 , 02
   Data 03 , 06 , 02 , 03
   Data 03 , 06 , 02 , 04
   Data 03 , 06 , 02 , 05

   Data 02 , 07 , 03 , 05
   Data 03 , 07 , 03 , 04
   Data 02 , 07 , 03 , 03
   Data 03 , 07 , 03 , 02
   Data 02 , 07 , 03 , 01

   Data 04 , 10 , 02 , 01
   Data 03 , 09 , 02 , 02
   Data 02 , 10 , 02 , 03
   Data 01 , 09 , 02 , 04
   Data 03 , 10 , 02 , 05

'Datensatz fr Bereichsende
   Data 00 , 00 , 00 , 00

'-------------------------------------------------------------------------------
'30. === I N T E R R U P T R O U T I N E =======================================
'-------------------------------------------------------------------------------
A_31_int:
'
'Timer 0
'-------
'Zeitbasis: 15 ms
Int_tim0:
   Timer0 = T0_tve                                'Timer 0: Voreinstellwert

   Incr Z_led
   Select Case Z_led
      Case 66                                     '66* 15 ms= 1 s
         If Z_zyk > K_zyk_ein Then                'nur in der Zykluspause
            Reset Led_sig                         'LED_gn ein
         End If
         Incr Z_zyk                               'Zykluszeit erhhen
'Zeitdauer fr Tageszyklus
         If Z_tag > 0 Then
            Decr Z_tag                            'im Sekundentakt
         End If
      Case 67
         Set Led_sig                              'LED aus
         Z_led = 0
   End Select

'Zykluszeit
   If Z_zyk > K_zyk_aus Then
      Z_zyk = 0
   End If

Return

'-------------------------------------------------------------------------------
'40. === U N T E R P R O G R A M M =============================================
'-------------------------------------------------------------------------------
A_41_up:
'
Up_tas:
'FT 1 - Funktionstaste 1
'Tastenabfrage fr Ultraschall Ein/Aus; sie erfolgt zwischen den Tonausgaben.
'Die Umschaltung ist erfolgt, wenn der Signalton (Intervall) ertnt.
   If T_1 = 0 Or T_2 = 0 Then
      Waitms 50                                   'Entprellzeit
'Auswertung T1
      If T_1 = 0 Then
         Set T_sig : Waitms 100 : Reset T_sig     'Tastenpiep 100 ms
         Toggle F_us                              'Flag <F_us> umschalten
         Z_zyk = 0                                'Zyklus neu starten
         Set Led_zyk                              'LED_rt aus
         Set Led_sig                              'LED_gn aus
         Set F_tas                                'SET Flag "Taste gedrckt"
      End If
'Auswertung T2
      If T_2 = 0 Then                             'Zhler initialisieren mit
         Z_tag = K_tag                            'Zeitlnge fr Dauerbetrieb
         Reset Led_zyk : Reset Led_sig            'Ein LED_ge
         Set T_sig : Waitms 100 : Reset T_sig     'Tastenpiep 100 ms
            Waitms 400                            'Zeitdauer: 400 ms
         Set Led_zyk : Set Led_sig                'Aus LED_ge
         Set F_tas                                'SET Flag "Taste gedrckt"
      End If
   End If

'Tastenabfrage
M_tas:
   If T_1 = 0 Or T_2 = 0 Then                     'Taste noch gedrckt
      Goto M_tas
   End If

Return

'-------------------------------------------------------------------------------
'50. === U N T E R P R O G R A M M - C A L L ===================================
'-------------------------------------------------------------------------------
A_51_cal:
'
'T_s: Dauer ...... [  s]    T_f: Frequenz ... [kHz]
'T_p: Pause ...... [  s]    T_v: Version .... [  -]
Sub C_ton(t_s As Byte , T_f As Byte , T_p As Byte , T_v As Byte)
'Wird die Zeitlnge fr die Tonausgabe berschritten, wird sie fr die festge-
'legte Zeit unterbrochen.
'Zykluszeit ermitteln
   Z_zyk = Z_zyk + T_s                            'Dauer
   Z_zyk = Z_zyk + T_p                            'Pause

'Ermittlung der Konstanten
'-Tonlnge [s]
   T_t = T_f * 1000
   T_t = T_t * T_s
   T_t = T_t * 2
   T_max = Int(t_t)
   T_max10 = T_max / 10                           '10%-Wert

'-Schrittweite
   T_sw = T_max / 30                              '<20 abgehackt

 '-Periodendauer [s]
   'T_w = 1 / T_f
   'T_w = T_w * 1000
   'T_w = T_w / 2
   T_w = 500 / T_f

   T_us = Int(t_w)
   T_us90 = T_us / 10                             'Zwischenwert: 10%
   T_us90 = T_us90 * 9                            '90%-Wert

'Frequenznderung x%
   T_zw = T_us / 50                               '50: 2%
   T_1pz = Int(t_zw)

Stop Timer0
   If F_us = 1 Then
      Reset Led_zyk                               'Ein: LED_rot
   Else
      Reset Led_sig                               'Ein: LED_grn
   End If

'Versionen der Tonausgabe
   Select Case T_v
'V 01
'-Zeitdauer mit konstanter Tonausgabe
      Case 1
         For Z_t = 1 To T_max
'Abfrage Tastenbettigung
            If T_1 = 0 Or T_2 = 0 Then Goto Mc1_exit
            Toggle T_usg
            Waitus T_us
         Next Z_t
'V 02
'-Zeitdauer mit ansschwellender Frequenz in Schritten (x%)
      Case 2
         Hz_t = 0
         For Z_t = 1 To T_max
'Abfrage Tastenbettigung
            If T_1 = 0 Or T_2 = 0 Then Goto Mc1_exit
            Incr Hz_t
            If Hz_t = T_sw Then
               Hz_t = 0
               T_us = T_us - T_1pz
            End If
            Toggle T_usg
            Waitus T_us
         Next Z_t
'V 03
'-Zeitdauer mit abschwellender Frequenz in Schritten (x%)
      Case 3
         Hz_t = 0
         For Z_t = 1 To T_max
'Abfrage Tastenbettigung
            If T_1 = 0 Or T_2 = 0 Then Goto Mc1_exit
            Incr Hz_t
            If Hz_t = T_sw Then
               Hz_t = 0
                  T_us = T_us + T_1pz
            End If

            Toggle T_usg
               Waitus T_us
         Next Z_t
'V 04
'-Zeitdauer mit wechselnder Frequenz (Sirene)
      Case 4
         For Z_t = 1 To T_max
'Abfrage Tastenbettigung
            If T_1 = 0 Or T_2 = 0 Then Goto Mc1_exit
            Incr Z_t10
            If Z_t10 = T_max10 Then
               Z_t10 = 0
               Toggle F_tog
            End If

            Toggle T_usg

            If F_tog = 0 Then
               Waitus T_us
            Else
               Waitus T_us90
            End If
         Next Z_t
'V 05
'-Zeitdauer mit wechselnder Frequenz mit Pause (Zufall)
      Case 5
         For Z_t = 1 To T_max
'Abfrage Tastenbettigung
            If T_1 = 0 Or T_2 = 0 Then Goto Mc1_exit
            Incr Z_t10
            If Z_t10 = T_max10 Then
               Z_t10 = 0
               Set F_tog
               Hz01 = Rnd(10) + 90
               T_t = T_us / 100
               T_us90 = T_t * Hz01
               Waitms 50
            End If

            Toggle T_usg

            Waitus T_us90
         Next Z_t
   End Select

Mc1_exit:
'LP ausschalten
   Reset T_usg
'LED ausschalten
   Set Led_sig
   Set Led_zyk

   Hz_t = 0

'Wartezeit nach der Tonausgabe
   For Hz01 = 1 To T_p                            'Pause
      Waitms 500                                  'Reaktionszeitverkrzung
      Gosub Up_tas                                'Tastenabfrage
      If F_tas = 1 Then
         Reset F_tas
         Goto Mc1_end
      End If
      Waitms 500
   Next Hz01

Mc1_end:
Start Timer0

End Sub

'###############################################################################